/*
|==========||==========|
GS Shader 2.1

By Goldshadow12
|==========||==========|
*/


// Original from Bicubic Shader by @bicubic7.

#include "uniformPerFrameConstants.h"

highp float hash( highp float n ){
	return fract(sin(n)*43758.5453);
}

highp float noise( highp vec2 x ){
	highp vec2 p = floor(x);
	highp vec2 f = fract(x);
    	f = f*f*(3.0-2.0*f);
    highp float n = p.x + p.y*57.0;
    highp float res = mix(mix( hash(n+  0.0), hash(n+  1.0),f.x), mix( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y);
return res;
}


highp float fbm(highp vec2 x, const float speed, const float density, const float s) {
	highp float times = TIME * speed;
	highp float v = .0;
	highp float a = .6;
	
	x += vec2(1.,3.)*times;
	vec2 shift = vec2(1)+ times;
    mat2 rot = mat2(cos(.5), sin(.5), -sin(.5), cos(.5));
	for (int i = 0; i < 5; i++){
		v += a * noise(x*2.);
		x = rot * (x) * 2. + shift;
		a *= .5;
	}
	v = pow(abs(v),.8);
	highp float c = v - (1. - density);
  if ( c < .0 )
	c = .0;
    v = 1. - (pow(s, c));
	return v;
}